import pandas as pd  
from sklearn.preprocessing import LabelEncoder 
import pickle 
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Preprocess the data by applying Label Encoding to 'savings_status' and 'employment'   
data_for_clustering['savings_status'] = LabelEncoder().fit_transform(data_for_clustering['savings_status'])   
data_for_clustering['employment'] = LabelEncoder().fit_transform(data_for_clustering['employment'])   

# Apply One-Hot Encoding to 'credit_history'   
data_for_clustering = pd.get_dummies(data_for_clustering, columns=['credit_history'], drop_first=True)

print("data_for_clustering:\n", data_for_clustering)    
pickle.dump(data_for_clustering,open("./ref_result/data_for_clustering.pkl","wb"))